#!/bin/sh
# Mobile Broadband Startup Service script v0.1 alpha by The Fan Club - April 2012
# acts as startup service script for nmcli to fire up Mobile Broadband Connections
# NOTE: Use the name of the Mobile Connection in the Network Manager as the 'id' 
# USAGE: start|stop|status
#
### BEGIN INIT INFO 
# Provides: mobile-broadband-connect 
# Required-Start: $remote_fs $syslog
# Required-Stop: $remote_fs $syslog
# Should-Start: $network
# Should-Stop: $network
# Default-Start: 3 4 5 
# Default-Stop: 0 1 6 
# Short-Description: Autoconnect 3G GSM
### END INIT INFO

NAME="mobile-broadband-connect"
DESC="Autoconnect 3G/4G GSM USB modem at startup"

test -x $DAEMON || exit 0

case "$1" in
   start)
      echo "Starting Mobile Broadband Connection."

      while true; do
          # testing...
         LC_ALL=C nmcli -t -f TYPE,STATE dev | grep -q "^gsm:disconnected$"
         if [ $? -eq 0 ]; then
            break
          else
            # no GSM modem detected yet, sleeping for a second
            sleep 1
          fi
      done

      # Once GSM modem detected, run the script
      nmcli -t con up id aero2
   ;;
   stop)
      echo "Stopping Mobile Broadband Connection."
      nmcli -t con down id aero2
      #nmcli -t nm wwan off 
   ;;
   status)
      # Check to see if the process is running with nmcli
       nmcli -p dev
   ;;
   
   *)
      echo "Mobile Broadband Startup Service"
      echo $"Usage: $0 {start|stop|status}"
      exit 1
esac
exit 0